<div class="modal fade" id="comment" tabindex="-1" role="dialog" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<?php if(!User::logged_in()) { ?>
				<div class="modal-header">
					<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
					<h4 class="modal-title"><?php echo $language['messages']['logged_in_action']; ?></h4>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-default" data-dismiss="modal"><?php echo $language['misc']['close_modal']; ?></button>
				</div>
			<?php } else { ?>
			<form method="post" role="form" class="comments">
				<div class="modal-header">
					<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
					<h4 class="modal-title"><?php echo $language['server']['comment']; ?></h4>
				</div>

				<div class="modal-body">

					<div class="form-group">
						<input type="hidden" name="token" value="<?php echo $token->hash; ?>" />
					</div>

					<div class="form-group">
						<textarea name="comment" class="form-control" rows="4" style="resize:none;"></textarea>
					</div>

				</div>

				<div class="modal-footer">
					<button type="button" class="btn btn-default" data-dismiss="modal"><?php echo $language['misc']['close_modal']; ?></button>
					<button type="submit" class="btn btn-default"><?php echo $language['forms']['submit']; ?></button>
				</div>
			</form>
			<?php } ?>
		</div>
	</div>
</div>

<script>
$(document).ready(function() {
	
	$('form.comments').submit(function(event) {
		/* Close the modal */
		$('#comment').modal('hide');
		
		/* Get the form element the submit button belongs to */
		var $form = $(this).closest('form');

		/* Get the values from elements on the specific form */
		var Data = $form.serializeArray();

		/* Post and get response */
		$.post('processing/process_comments.php', Data, function(data) {
			$('html, body').animate({scrollTop:0},'slow');

			var result = JSON.parse(data);

			/* Display success message */
			$('#response').html(result.message).fadeIn('slow');

			if(result.status) {
				/* Remove all the comments */
				$('#comments').empty();

				/* Initiate the commets again */
				showMore(0, 'processing/comments_show_more.php', '#comments');
			}

			setTimeout(function() {
				$('#response').fadeOut('slow');
			}, 5000);

			/* Clear the textarea */
			$('textarea').val('');

		});

		event.preventDefault();
	});

});
</script>